<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Editor Notes
 * Displays notes only visible within the backend editor
 */
if ( ! defined( 'ABSPATH' ) ) {  exit;  }    // Exit if accessed directly


if ( ! class_exists( 'avia_ss_editnotes' ) )
{
	class avia_ss_editnotes extends aviaShortcodeTemplate
	{
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$this->config['self_closing']	=	'no';
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']			= __('Editor Notes', 'avia_framework' );
				$this->config['tab']			= __('Spiderfly Elements', 'avia_framework' );
				$this->config['icon']			= $child_sc_imgs."notes.png";
				$this->config['order']			= 100;
				$this->config['target']			= 'avia-target-insert';
				$this->config['shortcode'] 		= 'av_editnotes';
				$this->config['modal_data'] 	= array('modal_class' => 'mediumscreen');
				$this->config['tooltip'] 	    = __('Creates a notes box visible only in the editor.', 'avia_framework' );
				$this->config['preview'] 		= "false";
				$this->config['id_name']		= 'id';
				$this->config['id_show']		= 'yes';
			}

			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					
				array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
					
					array(
							"name" 	=> __("Content",'avia_framework' ),
							"desc" 	=> __("Enter some content for this textblock",'avia_framework' ),
							"id" 	=> "content",
							"type" 	=> "textarea",
							"std" 	=> __("Click here to add your own text", "avia_framework" )
							),
					
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					
					array(
							"type" 	=> "close_tab",//close tab
							'nodescription' => true 
						),	
					
						
					array(
							"type" 	=> "close_tab_container", //close tab container
							'nodescription' => true
						),

				);

			}

			/**
			 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
			 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
			 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
			 *
			 *
			 * @param array $params this array holds the default values for $content and $args.
			 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
			 */
			function editor_element($params)
			{
				$params['class'] = "";
				$params['innerHtml'] = "<div class='avia_textblock avia_textblock_style' data-update_with='content' style='background-color:#fffce4 !important;'>".stripslashes(wpautop(trim(html_entity_decode( $params['content']) )))."</div>";
				return $params;
			}

			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string
			 */
			function shortcode_handler( $atts, $content = "", $shortcodename = "", $meta = "" )
			{
                $output .= '';
                return $output;
			}

	}
}