<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Modern Product Listing
 * Displays a promo listing for a page, post, or portfolio item with a modern style.
 */


if ( !class_exists( 'avia_promo_modern' ) ) 
{
	class avia_promo_modern extends aviaShortcodeTemplate
	{
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']		= __('Modern Promo', 'avia_framework' );
				$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
				$this->config['icon']		= $child_sc_imgs."modern-promo.png";
				$this->config['order']		= 94;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'promo_modern';
				$this->config['tooltip'] 	= __('Displays a promo listing for a page, post, or portfolio item with a modern style.', 'avia_framework' );
				$this->config['tinyMCE']    = array('disable'=>true);
				$this->config['preview'] 	= true;
			}
		
		public function __construct( $builder ) 
		{
			add_filter( 'avf_preview_window_css_files', array( $this, 'handler_avf_preview_window_css_files'), 10, 1 );
				
			parent::__construct( $builder );
		}

		public function handler_avf_preview_window_css_files( $css = array() )
		{
			
			if(is_rtl()): $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css'; else: $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css'; endif;
			
			$css[ $css_url ] = 1;
			return $css;
		}
		
		function extra_assets()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			}
		
			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{

				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
						
					array(	
							"name" 	=> __("Promo Type", 'avia_framework' ),
							"desc" 	=> __("Select which kind of promo you would like.", 'avia_framework' ),
							"id" 	=> "promo_type",
							"type" 	=> "select",
							"std" 	=> "page-promo",
							"subtype" => array( __("Page Promo", 'avia_framework' )=>'page-promo',  __("Post Promo", 'avia_framework' )=>'post-promo',  __("Portfolio Promo", 'avia_framework' )=>'portfolio-promo',  __("Custom", 'avia_framework' )=>'custom')
							), 
					
				    array(
						"name" 	=> __("Which Entry?", 'avia_framework' ),
							"desc" 	=> __("Select the Entry that should be displayed", 'avia_framework' ),
							"id" 	=> "page_link",
							"type" 	=> "select",
							"taxonomy" => "single",
							"subtype" => "page",
							"required" => array('promo_type','equals','page-promo'),
						),
				    array(
						"name" 	=> __("Which Entry?", 'avia_framework' ),
							"desc" 	=> __("Select the Entry that should be displayed", 'avia_framework' ),
							"id" 	=> "post_link",
							"type" 	=> "select",
							"taxonomy" => "single",
							"subtype" => "post",
							"required" => array('promo_type','equals','post-promo'),
						),
				    array(
						"name" 	=> __("Which Entry?", 'avia_framework' ),
							"desc" 	=> __("Select the Entry that should be displayed", 'avia_framework' ),
							"id" 	=> "portfolio_link",
							"type" 	=> "select",
							"taxonomy" => "single",
							"subtype" => "portfolio",
							"required" => array('promo_type','equals','portfolio-promo'),
						),
					array(
						"name" 	=> __("Custom Promo Link", 'avia_framework' ),
							"desc" 	=> __("Enter the URL to which you would like this promo to point. Leave blank to have no link.", 'avia_framework' ),
							"id" 	=> "custom_link",
							"type" 	=> "input",
							"required" => array('promo_type','equals','custom'),
						),
					array(
							"name" 	=> __("Choose Promo Image",'avia_framework' ),
							"desc" 	=> "",
							"id" 	=> "promo_image",
							"type" 	=> "image",
							"required" => array('promo_type','equals','custom'),
							"title" => __("Insert Image",'avia_framework' ),
							"button" => __("Insert",'avia_framework' ),
							"std" 	=> AviaBuilder::$path['imagesURL']."placeholder.jpg"),
					array(	
						"name" 	=> __("Title Override", 'avia_framework' ),
						"desc" 	=> __("Here you can change the promo title displayed. Leave blank to use the default title.", 'avia_framework' ),
						"id" 	=> "new_title",
						"std" 	=> "",
						"type" 	=> "input"),
						
					array(	
						"name" 	=> __("Extra Tagline", 'avia_framework' ),
						"desc" 	=> __("Here you can enter any brief text you want to promote a key feature of the promo.", 'avia_framework' ),
						"id" 	=> "extratag",
						"std" 	=> "",
						"type" 	=> "input"),
												
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Style Options" , 'avia_framework'),
							'nodescription' => true
						),
						
					array(	
							"name" 	=> __("Image Size", 'avia_framework' ),
							"desc" 	=> __("Select an image thumbnail size.", 'avia_framework' ),
							"id" 	=> "img_size",
							"type" 	=> "select",
							"required" => array('promo_type','not','custom'),
							"std" 	=> "gallery",
							"subtype" => array(__("Featured", 'avia_framework' )=>'featured' ,__("Featured Large", 'avia_framework' )=>'featured_large', __("Extra Large", 'avia_framework' )=>'extra_large', __("Shop Catalog", 'avia_framework' )=>'shop_catalog', __("Portfolio", 'avia_framework' )=>'portfolio', __("Portfolio Small", 'avia_framework' )=>'portfolio_small', __("Gallery", 'avia_framework' )=>'gallery', __("Masonry", 'avia_framework' )=>'masonry', __("Magazine", 'avia_framework' )=>'magazine', __("Modern Magazine", 'avia_framework' )=>'magazine_alt', __("Modern Product", 'avia_framework' )=>'product', __("Modern Product Alt", 'avia_framework' )=>'product_alt', __("Entry With Sidebar", 'avia_framework' )=>'entry_with_sidebar', __("Entry Without Sidebar", 'avia_framework' )=>'entry_without_sidebar')
							),
							
						
					array(	"name" 	=> __("Heading Size", 'avia_framework' ),
							"desc" 	=> __("Adjust the size of the product title in pixels.", 'avia_framework' ),
				            "id" 	=> "heading_size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(20,45,1, array( __("Default Size", 'avia_framework' )=>'30')),
				            "std" => ""),
							
					array(	
							"name" 	=> __("Extra Tagline Background Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the badge background.", 'avia_framework' ),
							"id" 	=> "extra_bg",
							"type" 	=> "colorpicker",
							"std" 	=> "#0074aa",
						), 
						
					array(
							"name" 	=> __("TIP",'avia_framework' ),
							"desc" 	=> __("If you make the Gradient Start and Gradient End options equal, the overlay effect will have no gradient and will have a hard edge.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
						),
							
					array(	"name" 	=> __("Overlay Transparency", 'avia_framework' ),
							"desc" 	=> __("Adjust the transparency of the overlay behind the product title.", 'avia_framework' ),
				            "id" 	=> "overlay",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(0.1,1,0.05, array( __("Default Transparency", 'avia_framework' )=>'0.6')),
				            "std" => ""),
							
					array(	"name" 	=> __("Gradient Start", 'avia_framework' ),
							"desc" 	=> __("Adjust where you would like the gradient effect to start. Values are a percentage relative to the bottom of the image.", 'avia_framework' ),
				            "id" 	=> "overlay_start",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(0,100,1, array( __("Default Gradient Start", 'avia_framework' )=>'10')),
							"container_class" => 'av_half',
				            "std" => ""),
							
					array(	"name" 	=> __("Gradient End", 'avia_framework' ),
							"desc" 	=> __("Adjust where you would like the gradient effect to end. Values are a percentage relative to the bottom of the image.", 'avia_framework' ),
				            "id" 	=> "overlay_end",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(0,100,1, array( __("Default Gradient End", 'avia_framework' )=>'50')),
							"container_class" => 'av_half',
				            "std" => ""),
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
														
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
				);

			}
			
			
			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element 
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string 
			 */
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{

				extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
			   $atts =  shortcode_atts(array('promo_type' => '', 'page_link' => '', 'post_link' => '', 'portfolio_link' => '', 'custom_link' => '', 'new_title' => '', 'promo_image' => '', 'tagline' => '', 'extratag' => '', 'extra_bg' => '', 'img_size' => 'shop_catalog','heading_size' => '30', 'overlay' => '0.6', 'overlay_start' => '10', 'overlay_end' => '50'
			                                 ), $atts, $this->config['shortcode']);
				
			    $promo_type = $atts['promo_type'];
				$new_title  = $atts['new_title'];
				$img_size  = $atts['img_size'];
				$heading_size  = $atts['heading_size'];
				$overlay = $atts['overlay'];
				$overlay_start = $atts['overlay_start'];
				$overlay_end = $atts['overlay_end'];
				$promo_image = $atts['promo_image'];
				$custom_link = $atts['custom_link'];

				if ($promo_type == 'page-promo'){
					$link == $atts['page_link'];
					$feature_image = get_the_post_thumbnail( $atts['page_link'], $img_size );
					$url = '<a href="'.get_permalink( $atts['page_link'] ).'" style="z-index:1001;"></a>';
					$page_title = get_the_title( $atts['page_link'] );
				}
				if ($promo_type == 'post-promo'){
					$link == $atts['post_link'];
					$feature_image = get_the_post_thumbnail( $atts['post_link'], $img_size );
					$url = '<a href="'.get_permalink( $atts['post_link'] ).'" style="z-index:1001;"></a>';
					$page_title = get_the_title( $atts['post_link'] );
				}
				if ($promo_type == 'portfolio-promo'){
					$link == $atts['portfolio_link'];
					$feature_image = get_the_post_thumbnail( $atts['portfolio_link'], $img_size );
					$url = '<a href="'.get_permalink( $atts['portfolio_link'] ).'" style="z-index:1001;"></a>';
					$page_title = get_the_title( $atts['portfolio_link'] );
				}
				if ($promo_type == 'custom'){
					$link == $atts['custom_link'];
					$feature_image = "<img src='".$promo_image."' />";
					if($custom_link) {$url = '<a href="'.$atts['custom_link'].'" style="z-index:1001;"></a>';}
				}
				
				if(!empty($new_title)) $page_title = $new_title;
				
				if (!empty($heading_size)) {$headstyling .= "font-size:".$heading_size."px !important; text-shadow: 1px 1px 1px #000000; z-index:1000;";}
				if(!empty($headstyling)) $headstyling = "style='{$headstyling}'";
				if ( (!empty($overlay)) || (!empty($overlay_start)) || (!empty($overlay_end)) ) {$overlaystyling .= "background-image: -webkit-linear-gradient(bottom, rgba(0, 0, 0, ".$overlay.") ".$overlay_start."%, transparent ".$overlay_end."%) !important; background-image: linear-gradient(to top, rgba(0, 0, 0, ".$overlay.") ".$overlay_start."%, transparent ".$overlay_end."%) !important; z-index:999;";}
				if(!empty($overlaystyling)) $overlaystyling = "style='{$overlaystyling}'";
			
				$extratag  = $atts['extratag'];
				$extra_bg  = $atts['extra_bg'];

				if($extratag){
				$extra = '<h3 class="title2" style="background-color:'.$extra_bg.' !important;">'.$extratag.'</h3>';
				}
				
			    $content_html = "";
			    $content_html .= '<figure class="modprod {$av_display_classes}">'. $feature_image;
				$content_html .= '<figcaption '.$overlaystyling.'>';
				$content_html .= '<h3 class="title1" '.$headstyling.'>'.$page_title.'</h3>';
				$content_html .= $extra;
				$content_html .= '</figcaption>'.$url;
				$content_html .= '</figure>';
  
			    $output  = "";
				$output .= do_shortcode( $content_html );
				
				return $output;
			}
	}
}
