<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Product Category Promo
 * Displays a promo for product categories.
 */
 
 if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('av_wc_a2cbutton', 'avia_please_install_woo');
	return;
}
 
add_action('wp_head','catpromo_style');
function catpromo_style( ){
	if(is_rtl()):
		echo '<style>@media only screen and (max-width: 767px){div.cat-promo {padding-right:0px !important;}}</style>';
	else:
		echo '<style>@media only screen and (max-width: 767px){div.cat-promo {padding-left:0px !important;}}</style>';
	endif;	
}

// Don't load directly
if ( !defined('ABSPATH') ) { die('-1'); }

if ( !class_exists( 'avia_cat_promo' ) ) 
{
	class avia_cat_promo extends aviaShortcodeTemplate{
			
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$this->config['name']		= __('Category Promo', 'avia_framework' );
				$this->config['tab']		= __('WooCommerce', 'avia_framework' );
				$this->config['icon']		= AviaBuilder::$path['imagesURL']."sc-heading.png";
				$this->config['order']		= 86;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'cat_promo';
				$this->config['modal_data'] = array('modal_class' => 'largescreen');
				$this->config['tooltip'] 	= __('Creates Product Category Promo', 'avia_framework' );
				$this->config['preview'] 	= false;
			}
			
			
			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
						
					array(
						"name" 	=> __("Which Category?", 'avia_framework' ),
						"desc" 	=> __("Select which entries should be displayed by selecting a taxonomy", 'avia_framework' ),
						"id" 	=> "heading",
						"type" 	=> "select",
						"taxonomy" => "product_cat",
					    "subtype" => "cat",
						"multiple"	=> 6
				),
					
					array(	
							"name" 	=> __("Promo Image Size", 'avia_framework' ),
							"desc" 	=> __("Select which kind of heading you want to display.", 'avia_framework' ),
							"id" 	=> "imgsize",
							"type" 	=> "select",
							"std" 	=> "100",
							"subtype" => AviaHtmlHelper::number_array(80,180,1)
							), 
							
					array(	
							"name" 	=> __("Subheading Type", 'avia_framework' ),
							"desc" 	=> __("Select a heading style", 'avia_framework' ),
							"id" 	=> "style",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Category Description", 'avia_framework' )=>'',  __("Custom", 'avia_framework' )=>'custom-sub')
							),  
				            				            
					array(
						"name" 	=> __("Subheading Text",'avia_framework' ),
						"desc" 	=> __("Add your subheading here",'avia_framework' ),
						"id" 	=> "content",
						"type" 	=> "textarea",
						"required" => array('style','not',''),
						"std" 	=> ""),   
						
					array(	"name" 	=> __("Subheading Size", 'avia_framework' ),
							"desc" 	=> __("Size of your subeading in Pixel", 'avia_framework' ),
				            "id" 	=> "subheading_size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(10,40,1),
				            "required" => array('subheading_active','not',''),
				            "std" => "15"), 
				            	
				    array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
						
						
					array(
							"type" 	=> "tab",
							"name"  => __("Promo Button" , 'avia_framework'),
							'nodescription' => true
						),
					
					array(	"name" 	=> __("Button Label", 'avia_framework' ),
							"desc" 	=> __("This is the text that appears on your button.", 'avia_framework' ),
				            "id" 	=> "label",
				            "type" 	=> "input",
				            "std" => __("SHOP NOW", 'avia_framework' )),
				    array(	
							"name" 	=> __("Button Link?", 'avia_framework' ),
							"desc" 	=> __("Where should your button link to?", 'avia_framework' ),
							"id" 	=> "link",
							"type" 	=> "linkpicker",
							"fetchTMPL"	=> true,
							"subtype" => array(	
												__('Set Manually', 'avia_framework' ) =>'manually',
												__('Single Entry', 'avia_framework' ) =>'single',
												__('Taxonomy Overview Page',  'avia_framework' )=>'taxonomy',
												),
							"std" 	=> ""),
							
					array(	
							"name" 	=> __("Open Link in new Window?", 'avia_framework' ),
							"desc" 	=> __("Select here if you want to open the linked page in a new window", 'avia_framework' ),
							"id" 	=> "link_target",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => AviaHtmlHelper::linking_options()),	
																
						
					array(	
							"name" 	=> __("Button Size", 'avia_framework' ),
							"desc" 	=> __("Choose the size of your button here", 'avia_framework' ),
							"id" 	=> "size",
							"type" 	=> "select",
							"std" 	=> "small",
							"subtype" => array(
								__('Small',   'avia_framework' ) =>'small',
								__('Medium',  'avia_framework' ) =>'medium',
								__('Large',   'avia_framework' ) =>'large',
								__('X Large',   'avia_framework' ) =>'x-large',
							)),

					array(	
							"name" 	=> __("Button Icon", 'avia_framework' ),
							"desc" 	=> __("Should an icon be displayed at the left side of the button", 'avia_framework' ),
							"id" 	=> "icon_select",
							"type" 	=> "select",
							"std" 	=> "yes",
							"subtype" => array(
								__('No Icon',  'avia_framework' ) =>'no',
								__('Yes, display Icon to the left',  'avia_framework' ) => 'yes' ,	
								__('Yes, display Icon to the right',  'avia_framework' ) =>'yes-right-icon',
								)),
					array(	
							"name" 	=> __("Icon Visibility",'avia_framework' ),
							"desc" 	=> __("Check to only display icon on hover",'avia_framework' ),
							"id" 	=> "icon_hover",
							"type" 	=> "checkbox",
							"std" 	=> "",
							"required" => array('icon_select','not_empty_and','no')
							),
					array(	
							"name" 	=> __("Button Icon",'avia_framework' ),
							"desc" 	=> __("Select an icon for your Button below",'avia_framework' ),
							"id" 	=> "icon",
							"type" 	=> "iconfont",
							"std" 	=> "",
							"required" => array('icon_select','not_empty_and','no')
							),
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
					
					array(
							"type" 	=> "tab",
							"name"	=> __("Colors",'avia_framework' ),
							'nodescription' => true
						), 
				            
				    array(	
							"name" 	=> __("Heading Color", 'avia_framework' ),
							"desc" 	=> __("Select a heading color", 'avia_framework' ),
							"id" 	=> "headingcolor",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-heading')
							), 
					
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Heading here", 'avia_framework' ),
							"id" 	=> "headingcustom_font",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('headingcolor','equals','custom-color-heading')
						),
						
					array(	
							"name" 	=> __("Subheading Color", 'avia_framework' ),
							"desc" 	=> __("Select a heading color", 'avia_framework' ),
							"id" 	=> "subcolor",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default Color", 'avia_framework' )=>'', __("Meta Color", 'avia_framework' )=>'meta-heading', __("Custom Color", 'avia_framework' )=>'custom-color-subheading')
							), 
					
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Heading here", 'avia_framework' ),
							"id" 	=> "custom_subfont",
							"type" 	=> "colorpicker",
							"std" 	=> "",
							"required" => array('subcolor','equals','custom-color-subheading')
						),
						
						
						
					array(	
							"name" 	=> __("Button Color", 'avia_framework' ),
							"desc" 	=> __("Choose a color for your button here", 'avia_framework' ),
							"id" 	=> "color",
							"type" 	=> "select",
							"std" 	=> "theme-color",
							"subtype" => array(	
												__('Colored Buttons', 'avia_framework' ) => array(
												__('Theme Color', 'avia_framework' )=>'theme-color',
												__('Theme Color Highlight', 'avia_framework' )=>'theme-color-highlight',
												__('Theme Color Subtle', 'avia_framework' )=>'theme-color-subtle',
												__('Custom Color', 'avia_framework' )=>'custom',
												)),
								),

							
					array(	
							"name" 	=> __("Custom Background Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom background color for your Button here", 'avia_framework' ),
							"id" 	=> "custom_bg",
							"type" 	=> "colorpicker",
							"std" 	=> "#444444",
							"required" => array('color','equals','custom')
						),	
						
					array(	
							"name" 	=> __("Custom Font Color", 'avia_framework' ),
							"desc" 	=> __("Select a custom font color for your Button here", 'avia_framework' ),
							"id" 	=> "custom_font",
							"type" 	=> "colorpicker",
							"std" 	=> "#ffffff",
							"required" => array('color','equals','custom')
						),	
						
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
						
								array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
									
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
					
				  
				);

			}
			
			 
			
			
			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element 
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string 
			 */
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{
				
				extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
				
			    extract(shortcode_atts(array('tag' => 'h3', 'heading'=>'', 'headingcolor'=>'', 'subcolor' =>'', 'image_width'=>'', 'style'=>'', 'headingcustom_font'=>'', 'custom_subfont'=>'', 'size'=>'', 'subheading_active' => '', 'subheading_size'=>'', 'label' => 'SHOP NOW', 'link' => '', 'link_target' => '', 'color' => 'theme-color', 'custom_bg' => '#444444', 'custom_font' => '#ffffff', 'size' => 'small', 'position' => 'left', 'icon_select' => 'no', 'icon' => '', 'font' =>'', 'icon_hover' => '',  'imgsize' => '120'), $atts, $this->config['shortcode']));
			
        		$output  = "";
        		$styling = "";
        		$subheading = "";
        		$border_styling = "";
        		$before = $after = "";
        		$class   = $meta['el_class'];
        		$subheading_extra = "";
        		
        		if($heading)
        		{
        			// add seo markup
                    $markup = avia_markup_helper(array('context' => 'entry_title','echo'=>false, 'custom_markup'=>$meta['custom_markup']));
					
					// filter heading for & symbol and convert them					
        			$heading = apply_filters('avia_ampersand', wptexturize($heading));
        			
        			//if the heading contains a strong tag make apply a custom class that makes the rest of the font appear smaller for a better effect
        			if( strpos($heading, '<strong>') !== false ) $class .= " av-thin-font";
        			
        			//apply the padding styling
	        		$styling .= "float:left; margin-bottom:0px; text-transform:uppercase;";
	        		
	        		// if the color is a custom hex value add the styling for both border and font
	        		if($headingcolor == "custom-color-heading" && $headingcustom_font)  
	        		{
	        			$styling .= "color:{$headingcustom_font};";
	        			$border_styling = "style='border-color:{$headingcustom_font}'";
	        			$subheading_extra = "av_custom_color";
	        		}
					
					if($subcolor == "custom-color-subheading" && $custom_subfont)  
	        		{
	        			$substyling .= "color:{$custom_subfont} !important;";
	        		}
	        		
	        		// if a custom font size is set apply it to the container and also apply the inherit class so the actual heading uses the size
	        		if(!empty($style) && !empty($size)) { $styling .= "font-size:{$size}px;"; $class .= " av-inherit-size";}
	        		
	        		//finish up the styling string
	        		if(!empty($styling)) $styling = "style='{$styling}'";
	        		
	        		//check if we got a subheading
	        		if( !empty( $style ) && !empty( $content ) )
	        		{
	        			
	        			$content = "<div class ='av-subheading {$subheading_extra} {$av_font_classes}' style='font-size:{$subheading_size}px; {$substyling}'><p style='padding:10px 0px;'>".ShortcodeHelper::avia_apply_autop(ShortcodeHelper::avia_remove_autop($content) )."</p></div>";
	        		
	        			$description = $content;
	        		} else {
						$prod_term = get_term($heading,'product_cat');
						$description = "<div class ='av-subheading {$subheading_extra} {$av_font_classes}' style='font-size:{$subheading_size}px; {$substyling}'><p style='padding:10px 0px;'>".$prod_term->description."</p></div>";
					}
					
					
					
					$display_char 	= av_icon($atts['icon'], $atts['font']);
					$extraClass 	= $atts['icon_hover'] ? "av-icon-on-hover" : "";
				
					if($atts['icon_select'] == "yes") $atts['icon_select'] = "yes-left-icon";
				
					$btnstyle = "";
					if($atts['color'] == "custom") 
					{
					$btnstyle .= "style='background-color:".$atts['custom_bg']."; border-color:".$atts['custom_bg']."; color:".$atts['custom_font']."; '";
					} else {
					$btnstyle .= "style='text-decoration:none !important;'";
					}

				
			    	$blank = strpos($atts['link_target'], '_blank') !== false ? ' target="_blank" ' : "";
			    	$blank .= strpos($atts['link_target'], 'nofollow') !== false ? ' rel="nofollow" ' : "";

			    	$link  = AviaHelper::get_url($atts['link']);
			    	$link  = ( ( $link == "http://" ) || ( $link == "manually" ) ) ? "" : $link;
			    
			    	$content_html = "";
			    	if('yes-left-icon' == $atts['icon_select']) $content_html .= "<span class='avia_button_icon avia_button_icon_left ' {$display_char}></span>";
					$content_html .= "<span class='avia_iconbox_title' >".$atts['label']."</span>";
			    	if('yes-right-icon' == $atts['icon_select']) $content_html .= "<span class='avia_button_icon avia_button_icon_right' {$display_char}></span>";
					
					
					$prod_category = get_terms( 'product_cat' );
					$product_cat = $cat->term_id;
					$product_cat = $heading;
					$cat_thumb_id = get_woocommerce_term_meta( $product_cat, 'thumbnail_id', true );
					$cat_thumb_url = wp_get_attachment_image_url( $cat_thumb_id, 'square' );
					$cat_wide_url = wp_get_attachment_image_url( $cat_thumb_id, 'entry_without_sidebar' );
					$prod_term = get_term($heading,'product_cat');
					$cat_name = $prod_term->name;
					
					$btncontent = "<a href='{$link}' class='avia-button {$extraClass} {$av_display_classes} ".$this->class_by_arguments('icon_select, color, size, position' , $atts, true)."' {$blank} {$btnstyle} >".$content_html."</a>";
				
					$btnoutput =  "<div class='avia-button-wrap avia-button-left ".$meta['el_class']."'>".$btncontent."</div>";

	        		//html markup
					$output .= '<div class="avia-image-container av-styling-circle av-hover-grow av-small-hide av-mini-hide avia-builder-el-8 el_before_av_heading avia-builder-el-first avia-align-left {$av_display_classes}" itemscope="itemscope" itemtype="https://schema.org/ImageObject"><div class="avia-image-container-inner"><img class="avia_image " src="'.$cat_thumb_url.'" width="'.$imgsize.'" height="'.$imgsize.'" alt="" title="Custom Coding" itemprop="thumbnailUrl"></div></div>';
	        		if(is_rtl()):
						$output .= "<div class='cat-promo av-special-heading-h3 {$headingcolor} {$style} {$class} {$av_display_classes}' style='padding-right:calc(".$imgsize."px + 15px);'>";
					else:
						$output .= "<div class='cat-promo av-special-heading-h3 {$headingcolor} {$style} {$class} {$av_display_classes}' style='padding-left:calc(".$imgsize."px + 15px);'>";
					endif;
	        		$output .= 	"<h3 class='av-special-heading-tag {$av_title_font_classes}' {$styling} $markup >".$cat_name."</h3>";
	        		$output .= 	"<div class='special-heading-border'><div class='special-heading-inner-border' {$border_styling}></div></div>";
					$output .= '<div class="avia-image-container  av-styling- av-hover-grow  av-desktop-hide av-medium-hide  avia-builder-el-9  el_after_av_heading  el_before_av_button   avia-align- " itemscope="itemscope" itemtype="https://schema.org/ImageObject"><div class="avia-image-container-inner"><img class="avia_image " src="'.$cat_wide_url.'" alt="" title="Custom Coding" itemprop="thumbnailUrl"></div></div>';
					$output .= 	$description;
	        		$output .= "{$btnoutput}</div>";
					    
        		}
        		
        		return $output;
        	}
			
		
	}
}
